;-----------------------------------------------------------------------------
; AutoIt Version: 3.1.1.100
; Author:Andrew Calcutt 	Last Edited:11/07/2007
; Script Function:	Functions
;-------------------------
;_no_gui.exe functions
;-------------------------
;_Logon($action, $logonuser = "", $logonpass = "", $startprogram = "")
;_Shutdown($shutdown, $action, $logonuser = "", $logonpass = "", $startprogram = "")
;_User($action, $user, $pass, $level)
;_Profile($action, $user)
;_Progress_Ref($action)
;_DeleteINI()
;_Defrag()
;_Desktop()
;_FolderOptions($settings, $HKUS1521)
;_StartMenu($settings, $HKUS1521)
;_Taskbar($settings, $HKUS1521)
;_TaskToolbar($toolbardir)
;_VisualSettings()
;_IniReadRegWrite($settings, $section1, $key1, $reg1, $reg2, $regtype, $regvalue1, $regvalue2)
;_IniReadRegWrite2($settings, $section1, $key1, $reg1, $reg2, $regtype, $regvalue1, $regvalue2, $regvalue3[, $regvalue4])
;_RunNetSupport($fullpath_exe, $netuser, $netpass, $netdom)
;-------------------------
;Prepsys.exe functions
;-------------------------
;_Set_INI_Settings()
;_Sophos_State()
;_McAfee_State()
;_Office_State()
;_Sysprep_User_State()
;_Folder_Options_State()
;_VisSettings_State()
;_StartMenuState()
;_StartMenuSwitch()
;_IniReadCheckbox_Ran($settings, ByRef $id, $name, $section1, $key1, $section2, $key2, $CR, $CT, $CW, $CH, $RR)
;_IniReadCheckbox($settings, ByRef $id, $name, $section1, $key1, $CR, $CT, $CW, $CH, $default = 0)
;_IniWriteCheckbox($settings, ByRef $id, $section1, $key1, $progress = "", $section2 = "", $key2 = "", $key3 = "", $key4 = "")
;_LabeledCombo($settings, ByRef $id, ByRef $id2, $label, $section1, $key1, $item0, $item1, $item2, $R, $T, $W, $H, $LR, $LT, $LW, $LH)
;_IniWriteCombo($settings, ByRef $id, $section1, $key1)
;_FileBrowse($default, ByRef $input, ByRef $browse, $R, $T, $W, $H, $BR, $BW)
;_FileBrowseSet(ByRef $exe, $label, $type)
;_State(Const $state, Const $1, Const $2, Const $3, Const $4, Const $5, Const $6, Const $7, Const $8, Const $9, Const $10)
;_ExeLocationWrite(Const $orig, Const $file, Const $settings, $section1, $key1)
;_SettingsFileDialog()
;_NetworkLogin($nluser = '', $nlpass = '', $nldom = '')
;_AdvancedFileOpenDialog($title, $directory, $filetypes, $options)
;_ChangeComputerName($newcomputername, $logonuser = "", $logonpass = "", $domain = "", $startprogram = "")
;_JoinToDomain($strUserDomain, $strUser, $strPassword, $strComputer, $strComputerDomain, $strOU)
;_RecordData($strComputer, $strUser, $strUserDomain, $strOU)
;_JoinDomainState()
;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------

;<-- ######################################################### _NO_GUI.EXE FUNC ######################################################### -->
Func _objErr()
	SetError(1)  ; to check for after this function returns
EndFunc   ;==>_objErr

Func _Logon($action, $logonuser = "", $logonpass = "", $domain = "", $startprogram = "")
	Select
		Case $action = "REMOVE"
			If IniRead($settings, "Program_Use_Only", "legalnoticecaption", "") <> "" Then RegWrite("HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\policies\system", "legalnoticecaption", "REG_SZ", IniRead($settings, "Program_Use_Only", "legalnoticecaption", ""))
			If IniRead($settings, "Program_Use_Only", "legalnoticetext", "") <> "" Then RegWrite("HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\policies\system", "legalnoticetext", "REG_SZ", IniRead($settings, "Program_Use_Only", "legalnoticetext", ""))
			RegWrite("HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Winlogon", "AutoAdminLogon", "REG_SZ", "0")
			RegWrite("HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Winlogon", "DefaultUserName", "REG_SZ", "")
			RegWrite("HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Winlogon", "DefaultPassword", "REG_SZ", "")
			RegWrite("HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Winlogon", "ForceAutoLogon", "REG_SZ", "0")
			RegDelete("HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Run", "Continue_Sysprep")
		Case $action = "ADD"
			If RegRead("HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\policies\system", "legalnoticecaption") <> "" Then IniWrite($settings, "Program_Use_Only", "legalnoticecaption", RegRead("HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\policies\system", "legalnoticecaption"))
			If RegRead("HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\policies\system", "legalnoticetext") <> "" Then IniWrite($settings, "Program_Use_Only", "legalnoticetext", RegRead("HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\policies\system", "legalnoticetext"))
			RegDelete("HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\policies\system", "legalnoticecaption")
			RegDelete("HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\policies\system", "legalnoticetext")
			RegWrite("HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Winlogon", "AutoAdminLogon", "REG_SZ", "1")
			RegWrite("HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Winlogon", "DefaultUserName", "REG_SZ", $logonuser)
			RegWrite("HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Winlogon", "DefaultPassword", "REG_SZ", $logonpass)
			RegWrite("HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Winlogon", "DefaultDomainName", "REG_SZ", $domain)
			If $logonpass = "" Then RegWrite("HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Winlogon", "DefaultPassword", "REG_SZ", "");FIX NO PASSWORD PROBLEM
			RegWrite("HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Winlogon", "ForceAutoLogon", "REG_SZ", "1")
			RegWrite('HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Run', 'Continue_Sysprep', "REG_SZ", $startprogram)
	EndSelect
EndFunc   ;==>_Logon


Func _Shutdown($shutdown, $action, $logonuser = "", $logonpass = "", $domain = "", $startprogram = "")
	Select
		Case $shutdown = "NONE"
			_Logon($action, $logonuser, $logonpass, $domain, $startprogram)
		Case $shutdown = "LOGOFF"
			_Logon($action, $logonuser, $logonpass, $domain, $startprogram)
			Shutdown(0)
			Exit
		Case $shutdown = "REBOOT"
			_Logon($action, $logonuser, $logonpass, $domain, $startprogram)
			Shutdown(2)
			Exit
	EndSelect
EndFunc   ;==>_Shutdown

Func _User($action, $user, $pass = "", $domain = @ComputerName, $level = "")
	Select
		Case $action = "ADD"
			$objLocalComputer = ObjGet("WinNT://" & @ComputerName); Init COM object
			$objUser = $objLocalComputer.Create ("user", $user); Create user
			$objUser.SetPassword ($pass)
			$objUser.SetInfo
			_User("SET_GROUP", $user, $pass, $domain, $level)
		Case $action = "REMOVE"
			_Profile("REMOVE", $user, $domain)
			$objLocalComputer = ObjGet("WinNT://" & @ComputerName); Init COM object
			$objLocalComputer.Delete ("user", $user); Delete user
		Case $action = "SET_GROUP"
			$dso = ObjGet("WinNT:")
			$objGroup = ObjGet("WinNT://" & @ComputerName & "/" & $level & ",group")
			$objUser = $dso.OpenDSObject ("WinNT://" & $domain & "/" & $user, $domain & "\" & $user, $pass, 1)
			$objGroup.Add ($objUser.ADsPath)
		Case $action = "REMOVE_GROUP"
			$objGroup = ObjGet("WinNT://" & @ComputerName & "/" & $level)
			$objUser = ObjGet("WinNT://" & $domain & "/" & $user)
			$objGroup.Remove ($objUser.ADsPath)
	EndSelect
EndFunc   ;==>_User

Func _Profile($action, $user, $computername = @ComputerName)
	;LOAD SYSTEM PROPERTIES - Advanced tab
	Run("RunDll32.exe shell32.dll,Control_RunDLL sysdm.cpl,,3")
	;CLICK USER PROFILE SETTINGS
	While 1
		If WinExists("System Properties") Then
			WinActivate("System Properties")
			ControlClick("System Properties", "Advanced", "Button4")
			ExitLoop
		EndIf
	WEnd
	While 1
		If WinExists("User Profiles") Then
			WinActivate("User Profiles")
			ExitLoop
		EndIf
	WEnd
	;PICK User
	$pickprofile = $computername & "\" & $user
	$pickprofile = ControlListView("User Profiles", "", "SysListView321", "FindItem", $pickprofile)
	ControlListView("User Profiles", "", "SysListView321", "Select", $pickprofile)
	
	Select
		Case $action = "COPY"
			ControlClick("User Profiles", "", "Button3")
			While 1
				If WinExists("Copy To") Then
					WinActivate("Copy To")
					;SET DESTINATION
					$copy_to = @HomeDrive & "\Documents and Settings\Default User"
					ControlSetText("Copy To", "", "Edit1", $copy_to)
					ControlClick("Copy To", "", "Button5")
					ExitLoop
				Else
					Sleep(200)
				EndIf
			WEnd
			While 1
				If WinExists("Confirm Copy") Then
					WinActivate("Confirm Copy")
					ControlClick("Confirm Copy", "", "Button1")
					ExitLoop
				Else
					Sleep(200)
				EndIf
			WEnd
			While 1
				If WinExists("Copy To") Then
					Sleep(500)
				Else
					ExitLoop
				EndIf
			WEnd
		Case $action = "REMOVE"
			;CLICK DELETE
			ControlClick("User Profiles", "", "Button2")
			WinWaitActive("Confirm Delete")
			ControlClick("Confirm Delete", "", "Button1")
	EndSelect
	
	While WinExists("User Profiles")
		WinClose("User Profiles")
	WEnd
	While WinExists("System Properties")
		WinClose("System Properties")
	WEnd
EndFunc   ;==>_Profile

Func _Progress_Ref($action)
	Select
		Case $action = "ADD_REF"
			$progressref += 1
			IniWrite($settings, "Program_Use_Only", "Progress_Ref", $progressref)
		Case $action = "ADD"
			$progressref2 += 1
			IniWrite($settings, "Program_Use_Only", "Progress_Ref2", $progressref2)
		Case $action = "SHOW"
			$run_percent = ($progressref2 / $progressref) * 100
			GUICtrlSetData($action_progress, $run_percent)
	EndSelect
EndFunc   ;==>_Progress_Ref

Func _DeleteINI()
	If IniRead($settings, "Script_Settings", "Delete_INI", "0") = 1 And IniRead($settings, "Script_Settings", "Run_Sysprep", "0") = 0 Then
		$progressref2 += 1
		FileDelete($settings)
	EndIf
	If IniRead($settings, "Script_Settings", "Run_Sysprep", "0") = 1 And IniRead($settings, "Program_Use_Only", "Ran_Sysprep", "0") = 1 Then
		If IniRead($settings, "Script_Settings", "Delete_INI", "0") = 1 Then $progressref2 += 1
		FileDelete($settings)
	EndIf
EndFunc   ;==>_DeleteINI

Func _Defrag()
	;-----------------------------------------------------------------------------
	; AutoIt Version: 3.1.0
	; Author:Andrew Calcutt 	Date:08/09/2005
	; Script Function: Defragments Computer
	;-----------------------------------------------------------------------------
	Run(@ComSpec & ' /c ' & 'dfrg.msc')
	WinWaitActive("Disk Defragmenter")
	
	ControlClick("Disk Defragmenter", "", "Button2")
	WinWaitActive("Disk Defragmenter", "Defragmentation is complete for:")
	ControlClick("Disk Defragmenter", "", "Button5")
	WinClose("Disk Defragmenter")
EndFunc   ;==>_Defrag

Func _Desktop($settings, $HKUS1521)
	;-----------------------------------------------------------------------------
	; AutoIt Version: 3.1.1
	; Author:Andrew Calcutt 	Date:08/31/2005
	; Script Function: Sets Desktop Settings
	;-----------------------------------------------------------------------------
	;Set Background
	Dim $system_image = ""
	Dim $defaultimgname = @HomeDrive & "\defaultimg.bmp"
	Dim $localimgname = IniRead($settings, "Background", "Local_Image", "")
	
	If FileExists($defaultimgname) Then
		$system_image = @WindowsDir & "\web\Wallpaper\defaultimg.bmp"
		FileCopy($defaultimgname, $system_image, 1)
	EndIf
	If FileExists($localimgname) And $localimgname <> "" And IniRead($settings, "Program_Use_Only", "UseLocalImage", "0") = 1 Then
		$system_image = $localimgname
	EndIf
	If $system_image = "" Then
		MsgBox(0, "Error", "No Background Image Found")
		$system_image = FileOpenDialog("Choose Background File", @WindowsDir & "\Web\Wallpaper", "Image (*.bmp)", 1)
	EndIf
	If FileExists($system_image) Then
		RegWrite("HKCU\Control Panel\Desktop", "Wallpaper", "REG_SZ", $system_image)
	EndIf
	;Desktop Items
	$regkey = $HKUS1521 & "\Software\Microsoft\Windows\CurrentVersion\Explorer"
	
	_IniReadRegWrite($settings, "Desktop_Items", "My_Documents", $regkey & "\HideDesktopIcons\ClassicStartMenu", "{450D8FBA-AD25-11D0-98A8-0800361B1103}", "REG_DWORD", "00000000", "00000001")
	_IniReadRegWrite($settings, "Desktop_Items", "My_Computer", $regkey & "\HideDesktopIcons\ClassicStartMenu", "{20D04FE0-3AEA-1069-A2D8-08002B30309D}", "REG_DWORD", "00000000", "00000001")
	_IniReadRegWrite($settings, "Desktop_Items", "My_Network_Places", $regkey & "\HideDesktopIcons\ClassicStartMenu", "{208D2C60-3AEA-1069-A2D7-08002B30309D}", "REG_DWORD", "00000000", "00000001")
	_IniReadRegWrite($settings, "Desktop_Items", "Internet_Explorer", $regkey & "\HideDesktopIcons\ClassicStartMenu", "{871C5380-42A0-1069-A2EA-08002B30309D}", "REG_DWORD", "00000000", "00000001")
	
	_IniReadRegWrite($settings, "Desktop_Items", "My_Documents", $regkey & "\HideDesktopIcons\NewStartPanel", "{450D8FBA-AD25-11D0-98A8-0800361B1103}", "REG_DWORD", "00000000", "00000001")
	_IniReadRegWrite($settings, "Desktop_Items", "My_Computer", $regkey & "\HideDesktopIcons\NewStartPanel", "{20D04FE0-3AEA-1069-A2D8-08002B30309D}", "REG_DWORD", "00000000", "00000001")
	_IniReadRegWrite($settings, "Desktop_Items", "My_Network_Places", $regkey & "\HideDesktopIcons\NewStartPanel", "{208D2C60-3AEA-1069-A2D7-08002B30309D}", "REG_DWORD", "00000000", "00000001")
	_IniReadRegWrite($settings, "Desktop_Items", "Internet_Explorer", $regkey & "\HideDesktopIcons\NewStartPanel", "{871C5380-42A0-1069-A2EA-08002B30309D}", "REG_DWORD", "00000000", "00000001")
	
	_IniReadRegWrite($settings, "Desktop_Items", "Enable_Desktop_Cleanup", $regkey & "\Desktop\CleanupWiz", "NoRun", "REG_DWORD", "00000000", "00000001")
	
	Run("RunDll32.exe USER32.DLL,UpdatePerUserSystemParameters ,1 ,True") ;set settings
EndFunc   ;==>_Desktop

Func _FolderOptions($settings, $HKUS1521)
	;-----------------------------------------------------------------------------
	; AutoIt Version: 3.1.1
	; Author:Andrew Calcutt 	Date:12/17/2005
	; Script Function: Sets Folder Settings
	;-----------------------------------------------------------------------------
	$regkey = $HKUS1521 & "\Software\Microsoft\Windows\CurrentVersion\Explorer\Advanced"
	_IniReadRegWrite($settings, "Folder_Options", "SearchNetPrinters", $regkey, "NoNetCrawling", "REG_DWORD", "0x00000000", "0x00000001")
	_IniReadRegWrite($settings, "Folder_Options", "DisplayFileSizeInFolderTips", $regkey, "FolderContentsInfoTip", "REG_DWORD", "0x00000001", "0x00000000")
	_IniReadRegWrite($settings, "Folder_Options", "SimpleViewInFolderListView", $regkey, "FriendlyTree", "REG_DWORD", "0x00000001", "0x00000000")
	_IniReadRegWrite($settings, "Folder_Options", "DisplaySystemFolderContents", $regkey, "WebViewBarricade", "REG_DWORD", "0x00000001", "0x00000000")
	_IniReadRegWrite($settings, "Folder_Options", "FullPathAddress", $HKUS1521 & "\Software\Microsoft\Windows\CurrentVersion\Explorer\CabinetState", "FullPathAddress", "REG_DWORD", "0x00000001", "0x00000000")
	_IniReadRegWrite($settings, "Folder_Options", "FullPathTitle", $HKUS1521 & "\Software\Microsoft\Windows\CurrentVersion\Explorer\CabinetState", "FullPath", "REG_DWORD", "0x00000001", "0x00000000")
	_IniReadRegWrite($settings, "Folder_Options", "FullPathTitle", $HKUS1521 & "\Software\Microsoft\Windows\CurrentVersion\Explorer\CabinetState", "Settings", "REG_BINARY", "0C0002000B01807C60000000", "0C0002000A01807C60000000")
	_IniReadRegWrite($settings, "Folder_Options", "CacheThumbnails", $regkey, "DisableThumbnailCache", "REG_DWORD", "0x00000000", "0x00000001")
	_IniReadRegWrite($settings, "Folder_Options", "ShowHiddenFiles", $regkey, "Hidden", "REG_DWORD", "0x00000001", "0x00000002")
	_IniReadRegWrite($settings, "Folder_Options", "ShowFileExtensions", $regkey, "HideFileExt", "REG_DWORD", "0x00000000", "0x00000001")
	_IniReadRegWrite($settings, "Folder_Options", "ShowHiddenSysFiles", $regkey, "ShowSuperHidden", "REG_DWORD", "0x00000001", "0x00000000")
	_IniReadRegWrite($settings, "Folder_Options", "LaunchWindowsInSeperateProcess", $regkey, "SeparateProcess", "REG_DWORD", "0x00000001", "0x00000000")
	_IniReadRegWrite($settings, "Folder_Options", "RememberFolderSettings", $regkey, "ClassicViewState", "REG_DWORD", "0x00000000", "0x00000001")
	_IniReadRegWrite($settings, "Folder_Options", "RestoreWindowsAtLogon", $regkey, "PersistBrowsers", "REG_DWORD", "0x00000001", "0x00000000")
	_IniReadRegWrite($settings, "Folder_Options", "ControlPanelInMyComputer", $HKUS1521 & "\Software\Microsoft\Windows\CurrentVersion\Explorer\HideMyComputerIcons", "{21EC2020-3AEA-1069-A2DD-08002B30309D}", "REG_DWORD", "0x00000000", "0x00000001")
	_IniReadRegWrite($settings, "Folder_Options", "ShowCompressedFilesInColor", $regkey, "ShowCompColor", "REG_DWORD", "0x00000001", "0x00000000")
	_IniReadRegWrite($settings, "Folder_Options", "ShowDesktopFolderInfoPopop", $regkey, "ShowInfoTip", "REG_DWORD", "0x00000001", "0x00000000")
	_IniReadRegWrite($settings, "Folder_Options", "UseSimpleFileSharing", "HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Control\Lsa", "forceguest", "REG_DWORD", "0x00000001", "0x00000000")
	_IniReadRegWrite($settings, "Folder_Options", "UseSimpleFileSharing", "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Lsa", "forceguest", "REG_DWORD", "0x00000001", "0x00000000")
EndFunc   ;==>_FolderOptions

Func _StartMenu($settings, $HKUS1521)
	;-----------------------------------------------------------------------------
	; AutoIt Version: 3.1.0
	; Author:Andrew Calcutt 	Date:08/09/2005
	; Script Function: Set Start Menu Options
	;-----------------------------------------------------------------------------
	$regkey = $HKUS1521 & "\Software\Microsoft\Windows\CurrentVersion\Explorer\Advanced"
	;CLASSIC START MENU OR NEW START MENU
	_IniReadRegWrite($settings, "StartMenu", "Classic_Menu", $HKUS1521 & "\Software\Microsoft\Windows\CurrentVersion\Explorer", "ShellState", "REG_BINARY", "2400000033880000000000000000000000000000010000000D0000000000000000000000", "2400000033880000000000000000000000000000010000000D0000000000000002000000")
	
	If IniRead($settings, "StartMenu", "Classic_Menu", "0") = 1 Then
		_IniReadRegWrite($settings, "Classic_Menu_Options", "DisplayAdminTools", $regkey, "StartMenuAdminTools", "REG_DWORD", "0x00000001", "0x00000000")
		_IniReadRegWrite($settings, "Classic_Menu_Options", "DisplayFavories", $regkey, "StartMenuFavorites", "REG_DWORD", "0x00000001", "0x00000000")
		_IniReadRegWrite($settings, "Classic_Menu_Options", "DisplayLogOff", $regkey, "StartMenuLogoff", "REG_DWORD", "0x00000001", "0x00000000")
		_IniReadRegWrite($settings, "Classic_Menu_Options", "DisplayRun", $regkey, "StartMenuRun", "REG_DWORD", "0x00000001", "0x00000000")
		_IniReadRegWrite($settings, "Classic_Menu_Options", "EnableDRAGandDROP", $regkey, "StartMenuChange", "REG_DWORD", "0x00000001", "0x00000000")
		_IniReadRegWrite($settings, "Classic_Menu_Options", "ExpandControlPanel", $regkey, "CascadeControlPanel", "REG_SZ", "YES", "NO")
		_IniReadRegWrite($settings, "Classic_Menu_Options", "ExpandMyDocuments", $regkey, "CascadeMyDocuments", "REG_SZ", "YES", "NO")
		_IniReadRegWrite($settings, "Classic_Menu_Options", "ExpandMyPictures", $regkey, "CascadeMyPictures", "REG_SZ", "YES", "NO")
		_IniReadRegWrite($settings, "Classic_Menu_Options", "ExpandNetworkConnections", $regkey, "CascadeNetworkConnections", "REG_SZ", "YES", "NO")
		_IniReadRegWrite($settings, "Classic_Menu_Options", "ExpandPrinters", $regkey, "CascadePrinters", "REG_SZ", "YES", "NO")
		_IniReadRegWrite($settings, "Classic_Menu_Options", "ScrollPrograms", $regkey, "StartMenuScrollPrograms", "REG_SZ", "YES", "NO")
		_IniReadRegWrite($settings, "Classic_Menu_Options", "UsePersonalizedMenus", $regkey, "IntelliMenus", "REG_DWORD", "0x00000001", "0x00000000")
		_IniReadRegWrite($settings, "Classic_Menu_Options", "EnableDragDrop", $regkey, "Start_EnableDragDrop", "REG_DWORD", "0x00000001", "0x00000000")
	Else
		_IniReadRegWrite($settings, "StartMenu", "ScrollPrograms", $regkey, "Start_ScrollPrograms", "REG_DWORD", "0x00000001", "0x00000000")
		_IniReadRegWrite($settings, "StartMenu", "ShowHelp", $regkey, "Start_ShowHelp", "REG_DWORD", "0x00000001", "0x00000000")
		_IniReadRegWrite($settings, "StartMenu", "ShowPrinters", $regkey, "Start_ShowPrinters", "REG_DWORD", "0x00000001", "0x00000000")
		_IniReadRegWrite($settings, "StartMenu", "ShowRun", $regkey, "Start_ShowRun", "REG_DWORD", "0x00000001", "0x00000000")
		_IniReadRegWrite($settings, "StartMenu", "ShowSearch", $regkey, "Start_ShowSearch", "REG_DWORD", "0x00000001", "0x00000000")
		_IniReadRegWrite($settings, "StartMenu", "ShowSetProgramAccessAndDefaults", $regkey, "Start_ShowSetProgramAccessAndDefaults", "REG_DWORD", "0x00000001", "0x00000000")
		_IniReadRegWrite($settings, "StartMenu", "StartMenuFavorites", $regkey, "StartMenuFavorites", "REG_DWORD", "0x00000001", "0x00000000")
		_IniReadRegWrite2($settings, "StartMenu", "ShowControlPanel", $regkey, "Start_ShowControlPanel", "REG_DWORD", "0x00000000", "0x00000001", "0x00000002")
		_IniReadRegWrite2($settings, "StartMenu", "ShowMyComputer", $regkey, "Start_ShowMyComputer", "REG_DWORD", "0x00000000", "0x00000001", "0x00000002")
		_IniReadRegWrite2($settings, "StartMenu", "ShowMyDocs", $regkey, "Start_ShowMyDocs", "REG_DWORD", "0x00000000", "0x00000001", "0x00000002")
		_IniReadRegWrite2($settings, "StartMenu", "ShowMyMusic", $regkey, "Start_ShowMyMusic", "REG_DWORD", "0x00000000", "0x00000001", "0x00000002")
		_IniReadRegWrite2($settings, "StartMenu", "ShowNetConn", $regkey, "Start_ShowNetConn", "REG_DWORD", "0x00000000", "0x00000001", "0x00000002")
		_IniReadRegWrite2($settings, "StartMenu", "ShowAdminTools", $regkey, "Start_AdminToolsRoot", "REG_DWORD", "0x00000000", "0x00000000", "0x00000002")
		_IniReadRegWrite2($settings, "StartMenu", "ShowAdminTools", $regkey, "StartMenuAdminTools", "REG_DWORD", "0x00000000", "0x00000001", "0x00000001")
	EndIf
EndFunc   ;==>_StartMenu

Func _Taskbar($settings, $HKUS1521)
	;-----------------------------------------------------------------------------
	; AutoIt Version: 3.1.0
	; Author:Andrew Calcutt 	Date:02/01/2006
	; Script Function: Sets Taskbar Options
	;-----------------------------------------------------------------------------
	Run("RunDll32.exe shell32.dll,Options_RunDLL 1");open taskbar and start menu properties
	WinWaitActive("Taskbar and Start Menu Properties")
	While WinExists("Taskbar and Start Menu Properties")
		If IniRead($settings, "Taskbar", "LockTaskbar", "0") = 1 Then
			If ControlCommand("Taskbar and Start Menu Properties", "", "Button1", "IsChecked", "") = 0 Then ControlClick("Taskbar and Start Menu Properties", "", "Button1")
		Else
			If ControlCommand("Taskbar and Start Menu Properties", "", "Button1", "IsChecked", "") = 1 Then ControlClick("Taskbar and Start Menu Properties", "", "Button1")
		EndIf
		If IniRead($settings, "Taskbar", "AutoHideTaskbar", "0") = 1 Then
			If ControlCommand("Taskbar and Start Menu Properties", "", "Button2", "IsChecked", "") = 0 Then ControlClick("Taskbar and Start Menu Properties", "", "Button2")
		Else
			If ControlCommand("Taskbar and Start Menu Properties", "", "Button2", "IsChecked", "") = 1 Then ControlClick("Taskbar and Start Menu Properties", "", "Button2")
		EndIf
		If IniRead($settings, "Taskbar", "KeepTaskbarOnTop", "0") = 1 Then
			If ControlCommand("Taskbar and Start Menu Properties", "", "Button3", "IsChecked", "") = 0 Then ControlClick("Taskbar and Start Menu Properties", "", "Button3")
		Else
			If ControlCommand("Taskbar and Start Menu Properties", "", "Button3", "IsChecked", "") = 1 Then ControlClick("Taskbar and Start Menu Properties", "", "Button3")
		EndIf
		If IniRead($settings, "Taskbar", "Group", "0") = 1 Then
			If ControlCommand("Taskbar and Start Menu Properties", "", "Button4", "IsChecked", "") = 0 Then ControlClick("Taskbar and Start Menu Properties", "", "Button4")
		Else
			If ControlCommand("Taskbar and Start Menu Properties", "", "Button4", "IsChecked", "") = 1 Then ControlClick("Taskbar and Start Menu Properties", "", "Button4")
		EndIf
		If IniRead($settings, "Taskbar", "ShowQuickLaunch", "0") = 1 Then
			If ControlCommand("Taskbar and Start Menu Properties", "", "Button5", "IsChecked", "") = 0 Then ControlClick("Taskbar and Start Menu Properties", "", "Button5")
		Else
			If ControlCommand("Taskbar and Start Menu Properties", "", "Button5", "IsChecked", "") = 1 Then ControlClick("Taskbar and Start Menu Properties", "", "Button5")
		EndIf
		If IniRead($settings, "Taskbar", "ShowClock", "0") = 1 Then
			If ControlCommand("Taskbar and Start Menu Properties", "", "Button6", "IsChecked", "") = 0 Then ControlClick("Taskbar and Start Menu Properties", "", "Button6")
		Else
			If ControlCommand("Taskbar and Start Menu Properties", "", "Button6", "IsChecked", "") = 1 Then ControlClick("Taskbar and Start Menu Properties", "", "Button6")
		EndIf
		If IniRead($settings, "Taskbar", "HideInactiveIcons", "0") = 1 Then
			If ControlCommand("Taskbar and Start Menu Properties", "", "Button7", "IsChecked", "") = 0 Then ControlClick("Taskbar and Start Menu Properties", "", "Button7")
		Else
			If ControlCommand("Taskbar and Start Menu Properties", "", "Button7", "IsChecked", "") = 1 Then ControlClick("Taskbar and Start Menu Properties", "", "Button7")
		EndIf
		If ControlCommand("Taskbar and Start Menu Properties", "", "Button13", "IsEnabled", "") = 1 Then ControlClick("Taskbar and Start Menu Properties", "", "Button13")
		WinClose("Taskbar and Start Menu Properties")
	WEnd
EndFunc   ;==>_Taskbar

Func _TaskToolbar($toolbardir)
	;-----------------------------------------------------------------------------
	; AutoIt Version: 3.1.0
	; Author:Andrew Calcutt 	Date:08/09/2005
	; Script Function: Creates a toolbar in the taskbar
	;-----------------------------------------------------------------------------
	MouseClick("right", @DesktopWidth, @DesktopHeight)
	Send("{DOWN}{RIGHT}{UP}{ENTER}")
	WinWaitActive("New Toolbar")
	ControlSetText("New Toolbar", "", "Edit1", $toolbardir)
	ControlClick("New Toolbar", "", "Button2")
EndFunc   ;==>_TaskToolbar

Func _VisualSettings()
	;-----------------------------------------------------------------------------
	; AutoIt Version: 3.1.0
	; Author:Andrew Calcutt 	Date:12/24/2005
	; Script Function: Sets Visual Settings
	;-----------------------------------------------------------------------------
	;LOAD SYSTEM PROPERTIES
	Run("RunDll32.exe shell32.dll,Control_RunDLL sysdm.cpl,,3")
	;CLICK USER PROFILE SETTINGS
	While 1
		If WinExists("System Properties") Then
			ControlClick("System Properties", "Advanced", "Button2")
			ExitLoop
		EndIf
	WEnd
	
	;SET OPTIONS
	WinWaitActive("Performance Options")
	Send("!P{TAB}")
	
	If IniRead($settings, "Visual_Effects", "AWWMAM", "0") = 1 Then Send("{SPACE}")
	Send("{DOWN}")
	If IniRead($settings, "Visual_Effects", "FOSMIV", "0") = 1 Then Send("{SPACE}")
	Send("{DOWN}")
	If IniRead($settings, "Visual_Effects", "FOSTIV", "0") = 1 Then Send("{SPACE}")
	Send("{DOWN}")
	If IniRead($settings, "Visual_Effects", "FOMIAC", "0") = 1 Then Send("{SPACE}")
	Send("{DOWN}")
	If IniRead($settings, "Visual_Effects", "SSUM", "0") = 1 Then Send("{SPACE}")
	Send("{DOWN}")
	If IniRead($settings, "Visual_Effects", "SSUMP", "0") = 1 Then Send("{SPACE}")
	Send("{DOWN}")
	If IniRead($settings, "Visual_Effects", "STSR", "0") = 1 Then Send("{SPACE}")
	Send("{DOWN}")
	If IniRead($settings, "Visual_Effects", "SWCWD", "0") = 1 Then Send("{SPACE}")
	Send("{DOWN}")
	If IniRead($settings, "Visual_Effects", "SOCB", "0") = 1 Then Send("{SPACE}")
	Send("{DOWN}")
	If IniRead($settings, "Visual_Effects", "STB", "0") = 1 Then Send("{SPACE}")
	Send("{DOWN}")
	If IniRead($settings, "Visual_Effects", "SEOSF", "0") = 1 Then Send("{SPACE}")
	Send("{DOWN}")
	If IniRead($settings, "Visual_Effects", "SSLB", "0") = 1 Then Send("{SPACE}")
	Send("{DOWN}")
	If IniRead($settings, "Visual_Effects", "UABIFEFT", "0") = 1 Then Send("{SPACE}")
	Send("{DOWN}")
	If IniRead($settings, "Visual_Effects", "UCTIF", "0") = 1 Then Send("{SPACE}")
	Send("{DOWN}")
	If IniRead($settings, "Visual_Effects", "UDSFILOTD", "0") = 1 Then Send("{SPACE}")
	Send("{DOWN}")
	If IniRead($settings, "Visual_Effects", "UVSOWAB", "0") = 1 Then Send("{SPACE}")
	
	ControlClick("Performance Options", "", "Button7")
	While WinExists("Performance Options")
		If ControlCommand("Performance Options", "", "Button7", "IsEnabled", "") Then
			Sleep(200)
		Else
			ControlClick("Performance Options", "", "Button5")
		EndIf
	WEnd
	While WinExists("System Properties")
		WinClose("System Properties")
	WEnd
EndFunc   ;==>_VisualSettings

Func _IniReadRegWrite($settings, $section1, $key1, $reg1, $reg2, $regtype, $regvalue1, $regvalue2)
	If IniRead($settings, $section1, $key1, "0") = 1 Then
		RegWrite($reg1, $reg2, $regtype, $regvalue1)
	Else
		RegWrite($reg1, $reg2, $regtype, $regvalue2)
	EndIf
EndFunc   ;==>_IniReadRegWrite

Func _IniReadRegWrite2($settings, $section1, $key1, $reg1, $reg2, $regtype, $regvalue1, $regvalue2, $regvalue3, $regvalue4 = "")
	If IniRead($settings, $section1, $key1, "1") = 0 Then RegWrite($reg1, $reg2, $regtype, $regvalue1)
	If IniRead($settings, $section1, $key1, "1") = 1 Then RegWrite($reg1, $reg2, $regtype, $regvalue2)
	If IniRead($settings, $section1, $key1, "1") = 2 Then RegWrite($reg1, $reg2, $regtype, $regvalue3)
	If $regvalue4 <> "" And IniRead($settings, $section1, $key1, "1") = 3 Then RegWrite($reg1, $reg2, $regtype, $regvalue4)
EndFunc   ;==>_IniReadRegWrite2

Func _RunNetSupport($fullpath_exe, $netuser, $netpass, $netdom, $wait = "1") ;edited 6/14/2007
	$errorflag = _RunWait($fullpath_exe, $wait)
	If $errorflag = 1 Then ;try again
		Sleep(5000)
		$errorflag = _RunWait($fullpath_exe, $wait)
		If $errorflag = 1 Then ;try again
			Sleep(5000)
			$errorflag = _RunWait($fullpath_exe, $wait)
			If $errorflag = 1 Then ;try again
				Sleep(5000)
				$errorflag = _RunWait($fullpath_exe, $wait)
				If $errorflag = 1 Then ;try again
					$msgbox = MsgBox(1, "Error", $fullpath_exe & " location invalid" & @CRLF & "Please choose the correct file")
					If $msgbox = 2 Then Exit
					$fullpath_exe = _AdvancedFileOpenDialog("Choose AutoRun File", $workingdir & "Extra", "AutoRun (*.exe;*.bat;*.cmd;*.msi)", 1 + 4)
					_RunNetSupport($fullpath_exe, $netuser, $netpass, $netdom)
				EndIf
			EndIf
		EndIf
	EndIf
EndFunc   ;==>_RunNetSupport

Func _RunWait($fullpath_exe, $wait);edited 6/14/2007
	If StringInStr($fullpath_exe, "\\") Then $directory = _NetworkShareLogon($fullpath_exe, $netuser, $netpass, $netdom);If file is located on a network drive, authenticate
	$return = 0
	If $wait = 1 Then
		RunWait($fullpath_exe)
		If @error Then $return = 1
	Else
		Run($fullpath_exe)
		If @error Then $return = 1
	EndIf
	Return $return
EndFunc   ;==>_RunWait

Func _NetworkShareLogon($fullfilename, $nslnetuser, $nslnetpass, $nslnetdom);Created 7/8/2006
	;Split direcotry path from file name
	If StringInStr($fullfilename, '"', 0, 2) Then $fullfilename = StringTrimRight($fullfilename, StringLen($fullfilename) - StringInStr($fullfilename, '"', 0, 2))
	Dim $error = 0, $count = 0 ;set error flag to zero, set count flag
	While StringInStr($fullfilename, "\", 0, $count + 1) <> 0 ;find last "\" in file path
		$count += 1
	WEnd
	$directory = StringTrimLeft(StringTrimRight($fullfilename, (StringLen($fullfilename) - StringInStr($fullfilename, "\", 0, $count)) + 1), StringInStr($fullfilename, '"'))
	RunWait('NET USE "' & $directory & '" ' & $nslnetpass & ' /user:' & $nslnetdom & '\' & $nslnetuser & ' /persistent:no')
	Return $directory
EndFunc   ;==>_NetworkShareLogon


;<-- ######################################################### PREPSYS.EXE FUNC ######################################################### -->

Func _Set_INI_Settings($settings_ini_file, $workingdir);modified 11/07/2007
	IniWrite($settings_ini_file, 'Script_Settings', 'Working_Dir', $workingdir)
	IniWrite($settings_ini_file, "Program_Use_Only", "Progress_Ref", $progressref)
	IniWrite($settings_ini_file, "Program_Use_Only", "Progress_Ref2", $progressref2)
	IniWrite($settings_ini_file, "Script_Settings", "Admin_Username", GUICtrlRead($username))
	IniWrite($settings_ini_file, "Script_Settings", "Admin_Password", _StringEncrypt(1, GUICtrlRead($password), "Prepsys", 2))
	
	
	IniDelete($settings_ini_file, "Admin_Domains")
	For $i = 1 To $AdminDomains[0]
		If $AdminDomains[$i] <> @ComputerName Then IniWrite($settings_ini_file, "Admin_Domains", $i, $AdminDomains[$i])
	Next
	IniDelete($settings_ini_file, "CP_Domains")
	For $i = 1 To $CPDomains[0]
		If $CPDomains[$i] <> @ComputerName Then IniWrite($settings_ini_file, "CP_Domains", $i, $CPDomains[$i])
	Next
	
	If GUICtrlRead($domain) = @ComputerName Or GUICtrlRead($domain) = "" Then
		IniDelete($settings_ini_file, "Script_Settings", "Admin_Domain")
	Else
		IniWrite($settings_ini_file, "Script_Settings", "Admin_Domain", GUICtrlRead($domain))
	EndIf
	;Start JoinDomain Settings
	If GUICtrlRead($machine_name) = @ComputerName Or GUICtrlRead($machine_name) = "" Or GUICtrlRead($UseServiceTagAsName) = 1 Then
		IniDelete($settings_ini_file, "JoinDomain", "MachineName")
	Else
		IniWrite($settings_ini_file, "JoinDomain", "MachineName", GUICtrlRead($machine_name))
	EndIf
	
	IniDelete($settings_ini_file, "Join_Domain_OU") ;start $OU
	IniDelete($settings_ini_file, "Join_Domain")
	For $i = 1 To $OUnames[0]
		IniWrite($settings_ini_file, "Join_Domain_OU", $OUnames[$i], $OUdata[$i])
		IniWrite($settings_ini_file, "Join_Domain", $OUnames[$i], $OUdomain[$i])
	Next
	IniWrite($settings_ini_file, "JoinDomain", "OUdefault", GUICtrlRead($join_to));end OU
	
	IniDelete($settings_ini_file, "OU_User_Domains")
	For $i = 1 To $OUuserdomains[0]
		IniWrite($settings_ini_file, "OU_User_Domains", $i, $OUuserdomains[$i])
	Next
	IniWrite($settings_ini_file, "JoinDomain", "Domain", GUICtrlRead($JD_domain))
	
	IniWrite($settings_ini_file, "JoinDomain", "Username", GUICtrlRead($JDusername))
	IniWrite($settings_ini_file, "JoinDomain", "Password", _StringEncrypt(1, GUICtrlRead($JDpassword), "Prepsys", 2))
	_IniWriteCheckbox($settings_ini_file, $MakeJDUserAdmin, "Script_Settings", "MakeJDUserAdmin")
	_IniWriteCheckbox($settings_ini_file, $UseJDUserAsDefaultAdmin, "Script_Settings", "UseJDUserAsDefaultAdmin")
	_IniWriteCheckbox($settings_ini_file, $UseJDUserAsCopyProfileUser, "Script_Settings", "UseJDUserAsCopyProfileUser")
	_IniWriteCheckbox($settings_ini_file, $RemoveJDAdminRights, "Script_Settings", "RemoveJDAdminRights")
	_IniWriteCheckbox($settings_ini_file, $UseServiceTagAsName, "Program_Use_Only", "UseServiceTagAsName")
	
	;End Join Domain Settings
	
	IniWrite($settings_ini_file, "Script_Settings", "Sysprep_Username", GUICtrlRead($username2))
	IniWrite($settings_ini_file, "Script_Settings", "Sysprep_Password", _StringEncrypt(1, GUICtrlRead($password2), "Prepsys", 2))
	
	If GUICtrlRead($domain2) = @ComputerName Or GUICtrlRead($domain2) = "" Then
		IniDelete($settings_ini_file, "Script_Settings", "Sysprep_Domain")
	Else
		IniWrite($settings_ini_file, "Script_Settings", "Sysprep_Domain", GUICtrlRead($domain2))
	EndIf
	
	IniWrite($settings_ini_file, "Background", "Local_Image", GUICtrlRead($localimgname))
	IniWrite($settings_ini_file, "Background", "Default_Image", GUICtrlRead($defaultimgname))
	_IniWriteCheckbox($settings_ini_file, $use_local_image, "Program_Use_Only", "UseLocalImage")
	
	;set "create copy user"
	If GUICtrlRead($user_create) = 1 Then IniWrite($settings_ini_file, "Program_Use_Only", "CreateCopyProfileUser", "1")
	If GUICtrlRead($user_existing) = 1 Then IniWrite($settings_ini_file, "Program_Use_Only", "CreateCopyProfileUser", "0")
	_IniWriteCheckbox($settings_ini_file, $DeleteCopyProfileUser, "Program_Use_Only", "DeleteCopyProfileUser")
	_IniWriteCheckbox($settings_ini_file, $shownetlogonprompt, "NetworkLogon", "ShowNetLoginPrompt")
	$shownetprompt = GUICtrlRead($shownetlogonprompt)
	
	;Write Run settings
	_IniWriteCheckbox($settings_ini_file, $remuser, "Script_Settings", "Delete_Start_User", 1, "Program_Use_Only", "Delete_Start_User_Step1", "Delete_Start_User_Step2")
	_IniWriteCheckbox($settings_ini_file, $joindomain, "Script_Settings", "Join_To_Domain", 1, "Program_Use_Only", "Joined_To_Domain")
	_IniWriteCheckbox($settings_ini_file, $wininstaller, "Script_Settings", "Install_WinInstaller", 1, "Program_Use_Only", "Installed_WinInstaller")
	_IniWriteCheckbox($settings_ini_file, $mcinstall, "Script_Settings", "Install_McAfee", 1, "Program_Use_Only", "Installed_McAfee")
	_IniWriteCheckbox($settings_ini_file, $spinstall, "Script_Settings", "Install_Sophos", 1, "Program_Use_Only", "Installed_Sophos")
	_IniWriteCheckbox($settings_ini_file, $vpninstall, "Script_Settings", "Install_VPN", 1, "Program_Use_Only", "Installed_VPN")
	_IniWriteCheckbox($settings_ini_file, $offinstall, "Script_Settings", "Install_Office", 1, "Program_Use_Only", "Installed_Office")
	_IniWriteCheckbox($settings_ini_file, $addofficetoolbar, "Script_Settings", "AddOfficeToolbar", 1, "Program_Use_Only", "AddedOfficeToolbar")
	_IniWriteCheckbox($settings_ini_file, $datatel, "Script_Settings", "Install_Datatel", 1, "Program_Use_Only", "Installed_Datatel")
	_IniWriteCheckbox($settings_ini_file, $deepfreeze, "Script_Settings", "Install_DeepFreeze", 1, "Program_Use_Only", "Installed_DeepFreeze")
	_IniWriteCheckbox($settings_ini_file, $extrainstall, "Script_Settings", "Run_Extra", 1, "Program_Use_Only", "Ran_Extra")
	_IniWriteCheckbox($settings_ini_file, $waitupdate, "Script_Settings", "Wait_Updates", 1, "Program_Use_Only", "Waited_For_Updates")
	_IniWriteCheckbox($settings_ini_file, $startmenu, "Script_Settings", "Set_Start_Menu", 1, "Program_Use_Only", "Set_Start_Menu")
	_IniWriteCheckbox($settings_ini_file, $vissettings, "Script_Settings", "Set_Visual_Settings", 1, "Program_Use_Only", "Set_Visual_Settings")
	_IniWriteCheckbox($settings_ini_file, $folderoptions, "Script_Settings", "Set_Folder_Options", 1, "Program_Use_Only", "Set_Folder_Options")
	_IniWriteCheckbox($settings_ini_file, $turnoffautoupdate, "Script_Settings", "AutoUpdate", 1, "Program_Use_Only", "AutoUpdate")
	_IniWriteCheckbox($settings_ini_file, $deleteiconcache, "Script_Settings", "DeleteIconCache", 1, "Program_Use_Only", "DeleteIconCache")
	_IniWriteCheckbox($settings_ini_file, $copyprofile, "Script_Settings", "Copy_Profile", 1, "Program_Use_Only", "Copy_Profile_Step1", "Copy_Profile_Step2", "Copy_Profile_Step3")
	_IniWriteCheckbox($settings_ini_file, $cleansms, "Script_Settings", "Clean_SMS", 1, "Program_Use_Only", "Cleaned_SMS")
	_IniWriteCheckbox($settings_ini_file, $mcguid, "Script_Settings", "Remove_McAfee_GUID", 1, "Program_Use_Only", "Removed_McAfee_GUID")
	_IniWriteCheckbox($settings_ini_file, $defragment, "Script_Settings", "Defrag", 1, "Program_Use_Only", "Defraged")
	_IniWriteCheckbox($settings_ini_file, $deleteini, "Script_Settings", "Delete_INI", 1, "Program_Use_Only", "Defraged")
	_IniWriteCheckbox($settings_ini_file, $addprepsystostartup, "Script_Settings", "addprepsystostartup", 1, "Program_Use_Only", "addedprepsystostartup_Step1", "addedprepsystostartup_Step2")
	_IniWriteCheckbox($settings_ini_file, $runsysprep, "Script_Settings", "Run_Sysprep", 1, "Program_Use_Only", "Ran_Sysprep")
	
	;Write visual Settings
	_IniWriteCheckbox($settings_ini_file, $AWWMAM, "Visual_Effects", "AWWMAM")
	_IniWriteCheckbox($settings_ini_file, $FOSMIV, "Visual_Effects", "FOSMIV")
	_IniWriteCheckbox($settings_ini_file, $FOSTIV, "Visual_Effects", "FOSTIV")
	_IniWriteCheckbox($settings_ini_file, $SSUM, "Visual_Effects", "SSUM")
	_IniWriteCheckbox($settings_ini_file, $SSUMP, "Visual_Effects", "SSUMP")
	_IniWriteCheckbox($settings_ini_file, $STSR, "Visual_Effects", "STSR")
	_IniWriteCheckbox($settings_ini_file, $SWCWD, "Visual_Effects", "SWCWD")
	_IniWriteCheckbox($settings_ini_file, $SOCB, "Visual_Effects", "SOCB")
	_IniWriteCheckbox($settings_ini_file, $STB, "Visual_Effects", "STB")
	_IniWriteCheckbox($settings_ini_file, $SEOSF, "Visual_Effects", "SEOSF")
	_IniWriteCheckbox($settings_ini_file, $SSLB, "Visual_Effects", "SSLB")
	_IniWriteCheckbox($settings_ini_file, $UABIFEFT, "Visual_Effects", "UABIFEFT")
	_IniWriteCheckbox($settings_ini_file, $UCTIF, "Visual_Effects", "UCTIF")
	_IniWriteCheckbox($settings_ini_file, $UDSFILOTD, "Visual_Effects", "UDSFILOTD")
	_IniWriteCheckbox($settings_ini_file, $UVSOWAB, "Visual_Effects", "UVSOWAB")
	;Write Desktop Settings
	_IniWriteCheckbox($settings_ini_file, $mydocs, "Desktop_Items", "My_Documents")
	_IniWriteCheckbox($settings_ini_file, $mycomp, "Desktop_Items", "My_Computer")
	_IniWriteCheckbox($settings_ini_file, $mynetplaces, "Desktop_Items", "My_Network_Places")
	_IniWriteCheckbox($settings_ini_file, $iexplorer, "Desktop_Items", "Internet_Explorer")
	_IniWriteCheckbox($settings_ini_file, $cleandesk, "Desktop_Items", "Enable_Desktop_Cleanup")
	;Write Start Menu Settings
	_IniWriteCombo($settings_ini_file, $ShowControlPanel, "StartMenu", "ShowControlPanel")
	_IniWriteCombo($settings_ini_file, $ShowMyComputer, "StartMenu", "ShowMyComputer")
	_IniWriteCombo($settings_ini_file, $ShowMyDocs, "StartMenu", "ShowMyDocs")
	_IniWriteCombo($settings_ini_file, $ShowMyMusic, "StartMenu", "ShowMyMusic")
	_IniWriteCombo($settings_ini_file, $ShowMyPics, "StartMenu", "ShowMyPics")
	_IniWriteCombo($settings_ini_file, $ShowNetConn, "StartMenu", "ShowNetConn")
	_IniWriteCombo($settings_ini_file, $ShowAdminTools, "StartMenu", "ShowAdminTools")
	_IniWriteCheckbox($settings_ini_file, $ShowSetProgramAccessAndDefaults, "StartMenu", "ShowSetProgramAccessAndDefaults")
	_IniWriteCheckbox($settings_ini_file, $StartMenuFavorites, "StartMenu", "StartMenuFavorites")
	_IniWriteCheckbox($settings_ini_file, $EnableDragDrop, "StartMenu", "EnableDragDrop")
	_IniWriteCheckbox($settings_ini_file, $ScrollPrograms2, "StartMenu", "ScrollPrograms")
	_IniWriteCheckbox($settings_ini_file, $ShowHelp, "StartMenu", "ShowHelp")
	_IniWriteCheckbox($settings_ini_file, $ShowPrinters, "StartMenu", "ShowPrinters")
	_IniWriteCheckbox($settings_ini_file, $ShowRun, "StartMenu", "ShowRun")
	_IniWriteCheckbox($settings_ini_file, $ShowSearch, "StartMenu", "ShowSearch")
	_IniWriteCheckbox($settings_ini_file, $Classic_Menu, "StartMenu", "Classic_Menu")
	;write Classic  Menu Settings
	_IniWriteCheckbox($settings_ini_file, $DisplayAdminTools, "Classic_Menu_Options", "DisplayAdminTools")
	_IniWriteCheckbox($settings_ini_file, $DisplayFavories, "Classic_Menu_Options", "DisplayFavories")
	_IniWriteCheckbox($settings_ini_file, $DisplayLogOff, "Classic_Menu_Options", "DisplayLogOff")
	_IniWriteCheckbox($settings_ini_file, $DisplayRun, "Classic_Menu_Options", "DisplayRun")
	_IniWriteCheckbox($settings_ini_file, $EnableDRAGandDROP, "Classic_Menu_Options", "EnableDRAGandDROP")
	_IniWriteCheckbox($settings_ini_file, $ExpandControlPanel, "Classic_Menu_Options", "ExpandControlPanel")
	_IniWriteCheckbox($settings_ini_file, $ExpandMyDocuments, "Classic_Menu_Options", "ExpandMyDocuments")
	_IniWriteCheckbox($settings_ini_file, $ExpandMyPictures, "Classic_Menu_Options", "ExpandMyPictures")
	_IniWriteCheckbox($settings_ini_file, $ExpandNetworkConnections, "Classic_Menu_Options", "ExpandNetworkConnections")
	_IniWriteCheckbox($settings_ini_file, $ExpandPrinters, "Classic_Menu_Options", "ExpandPrinters")
	_IniWriteCheckbox($settings_ini_file, $ScrollPrograms, "Classic_Menu_Options", "ScrollPrograms")
	_IniWriteCheckbox($settings_ini_file, $UsePersonalizedMenus, "Classic_Menu_Options", "UsePersonalizedMenus")
	;write taskbar settings
	_IniWriteCheckbox($settings_ini_file, $LockTaskbar, "Taskbar", "LockTaskbar")
	_IniWriteCheckbox($settings_ini_file, $AutoHideTaskbar, "Taskbar", "AutoHideTaskbar")
	_IniWriteCheckbox($settings_ini_file, $KeepTaskbarOnTop, "Taskbar", "KeepTaskbarOnTop")
	_IniWriteCheckbox($settings_ini_file, $Group, "Taskbar", "Group")
	_IniWriteCheckbox($settings_ini_file, $ShowQuickLaunch, "Taskbar", "ShowQuickLaunch")
	_IniWriteCheckbox($settings_ini_file, $ShowClock, "Taskbar", "ShowClock")
	_IniWriteCheckbox($settings_ini_file, $HideInactiveIcons, "Taskbar", "HideInactiveIcons")
	;Write Folder settings
	_IniWriteCheckbox($settings_ini_file, $SearchNetPrinters, "Folder_Options", "SearchNetPrinters")
	_IniWriteCheckbox($settings_ini_file, $DisplayFileSizeInFolderTips, "Folder_Options", "DisplayFileSizeInFolderTips")
	_IniWriteCheckbox($settings_ini_file, $SimpleViewInFolderListView, "Folder_Options", "SimpleViewInFolderListView")
	_IniWriteCheckbox($settings_ini_file, $DisplaySystemFolderContents, "Folder_Options", "DisplaySystemFolderContents")
	_IniWriteCheckbox($settings_ini_file, $FullPathAddress, "Folder_Options", "FullPathAddress")
	_IniWriteCheckbox($settings_ini_file, $FullPathTitle, "Folder_Options", "FullPathTitle")
	_IniWriteCheckbox($settings_ini_file, $CacheThumbnails, "Folder_Options", "CacheThumbnails")
	_IniWriteCheckbox($settings_ini_file, $ShowHiddenFiles, "Folder_Options", "ShowHiddenFiles")
	_IniWriteCheckbox($settings_ini_file, $ShowFileExtensions, "Folder_Options", "ShowFileExtensions")
	_IniWriteCheckbox($settings_ini_file, $ShowHiddenSysFiles, "Folder_Options", "ShowHiddenSysFiles")
	_IniWriteCheckbox($settings_ini_file, $LaunchWindowsInSeperateProcess, "Folder_Options", "LaunchWindowsInSeperateProcess")
	_IniWriteCheckbox($settings_ini_file, $RememberFolderSettings, "Folder_Options", "RememberFolderSettings")
	_IniWriteCheckbox($settings_ini_file, $RestoreWindowsAtLogon, "Folder_Options", "RestoreWindowsAtLogon")
	_IniWriteCheckbox($settings_ini_file, $ControlPanelInMyComputer, "Folder_Options", "ControlPanelInMyComputer")
	_IniWriteCheckbox($settings_ini_file, $ShowCompressedFilesInColor, "Folder_Options", "ShowCompressedFilesInColor")
	_IniWriteCheckbox($settings_ini_file, $ShowDesktopFolderInfoPopop, "Folder_Options", "ShowDesktopFolderInfoPopop")
	If StringInStr(GUICtrlRead($APTS_settingsfile_Combo), "\\") = 0 And StringInStr(GUICtrlRead($APTS_settingsfile_Combo), ":") = 0 Then
		$settings_ini_filefile2 = @ScriptDir & "\settings\" & GUICtrlRead($APTS_settingsfile_Combo)
	Else
		$settings_ini_filefile2 = GUICtrlRead($APTS_settingsfile_Combo)
	EndIf
	$PrepsysLocation2 = '"' & GUICtrlRead($PrepsysLocation) & '" /s="' & $settings_ini_filefile2 & '" /t="' & GUICtrlRead($opentotab) & '"'
	If GUICtrlRead($AutorunPrepsysOnStartup) = 1 Then $PrepsysLocation2 = $PrepsysLocation2 & '" /r"'
	IniWrite($settings_ini_file, "Program_Use_Only", "PrepsysLocation", $PrepsysLocation2)
	IniWrite($settings_ini_file, "Program_Use_Only", "APTS_PrepsysLocation", GUICtrlRead($PrepsysLocation))
	IniWrite($settings_ini_file, "Program_Use_Only", "APTS_settingsfile", GUICtrlRead($APTS_settingsfile_Combo))
	IniWrite($settings_ini_file, "Program_Use_Only", "APTS_tab", GUICtrlRead($opentotab))
	_IniWriteCheckbox($settings_ini_file, $AutorunPrepsysOnStartup, "Program_Use_Only", "AutorunPrepsysOnStartup")
	IniWrite($settings_ini_file, "OFFICE", "OfficeToolbarDir", GUICtrlRead($toolbardir2))
	;Program Locations
	_ExeLocationWrite($mcafee_exe, $mcafee_exe2, $settings_ini_file, "Program_Locations", "mcafee_exe")
	_ExeLocationWrite($mcafee_patch_exe, $mcafee_patch_exe2, $settings_ini_file, "Program_Locations", "mcafee_patch_exe")
	_ExeLocationWrite($sophos_exe, $sophos_exe2, $settings_ini_file, "Program_Locations", "sophos_exe")
	_ExeLocationWrite($vpn_exe, $vpn_exe2, $settings_ini_file, "Program_Locations", "vpn_exe")
	_ExeLocationWrite($office_exe, $office_exe2, $settings_ini_file, "Program_Locations", "office_exe")
	_ExeLocationWrite($datatel_exe, $datatel_exe2, $settings_ini_file, "Program_Locations", "datatel_exe")
	_ExeLocationWrite($deepfreeze_exe, $deepfreeze_exe2, $settings_ini_file, "Program_Locations", "deepfreeze_exe")
	_ExeLocationWrite($cleansms_exe, $cleansms_exe2, $settings_ini_file, "Program_Locations", "cleansms_exe")
	_ExeLocationWrite($wininstaller_exe, $wininstaller_exe2, $settings_ini_file, "Program_Locations", "wininstaller_exe")
	
	;START SET EXTRA PROGRAMS
	IniDelete($settings_ini_file, "ExtraAutoRuns")
	If _GUICtrlListViewGetItemCount($extralist) <> 0 Then
		Local $a_list[_GUICtrlListViewGetItemCount($extralist) ], $x
		If IsArray($a_list) Then
			For $x = 0 To _GUICtrlListViewGetItemCount($extralist) - 1
				$a_list[$x] = _GUICtrlListViewGetItemText($extralist, $x)
				If GUICtrlRead($extrainstall) = 1 Then _Progress_Ref("ADD_REF")
			Next
			For $x = 0 To UBound($a_list) - 1
				IniWrite($settings_ini_file, "ExtraAutoRuns", $x, $a_list[$x])
				If StringInStr($a_list[$x], "\\") And GUICtrlRead($extrainstall) = 1 Then $requestnetwork = 1
			Next
		EndIf
	EndIf
	IniWrite($settings_ini_file, "Program_Use_Only", "extra_lastrun", "1") ; reset extra programs progress
	_IniWriteCheckbox($settings_ini_file, $extrareboot, "Program_Use_Only", "ExtraInstallReboot")
	;END SET EXTRA PROGRAMS
	
	;If network drive used(idendtified by "\\") and set to run, Set flag for network logon prompt
	If StringInStr(GUICtrlRead($mcafee_exe2), "\\") And GUICtrlRead($mcinstall) = 1 Then $requestnetwork = 1
	If StringInStr(GUICtrlRead($mcafee_patch_exe2), "\\") And GUICtrlRead($mcinstall) = 1 Then $requestnetwork = 1
	If StringInStr(GUICtrlRead($sophos_exe2), "\\") And GUICtrlRead($spinstall) = 1 Then $requestnetwork = 1
	If StringInStr(GUICtrlRead($vpn_exe2), "\\") And GUICtrlRead($vpninstall) = 1 Then $requestnetwork = 1
	If StringInStr(GUICtrlRead($office_exe2), "\\") And GUICtrlRead($offinstall) = 1 Then $requestnetwork = 1
	If StringInStr(GUICtrlRead($datatel_exe2), "\\") And GUICtrlRead($datatel) = 1 Then $requestnetwork = 1
	If StringInStr(GUICtrlRead($deepfreeze_exe2), "\\") And GUICtrlRead($deepfreeze) = 1 Then $requestnetwork = 1
	If StringInStr(GUICtrlRead($cleansms_exe2), "\\") And GUICtrlRead($cleansms) = 1 Then $requestnetwork = 1
	If StringInStr(GUICtrlRead($PrepsysLocation), "\\") And GUICtrlRead($addprepsystostartup) = 1 Then $requestnetwork = 1
	
	_NetworkLogin($settings_ini_file, GUICtrlRead($JDusername), GUICtrlRead($JDpassword), GUICtrlRead($JD_domain)); show logon promt if $requestnetwork = 1
	
	IniWrite($settings_ini_file, "Program_Use_Only", "Progress_Ref2", "0")
	
EndFunc   ;==>_Set_INI_Settings

Func _Sophos_State()
	If GUICtrlRead($mcinstall) = 1 Then
		GUICtrlSetState($spinstall, $GUI_UNCHECKED)
		GUICtrlSetState($spinstall, $GUI_DISABLE)
	Else
		GUICtrlSetState($spinstall, $GUI_ENABLE)
	EndIf
EndFunc   ;==>_Sophos_State

Func _McAfee_State()
	If GUICtrlRead($spinstall) = 1 Then
		GUICtrlSetState($mcinstall, $GUI_UNCHECKED)
		GUICtrlSetState($mcinstall, $GUI_DISABLE)
	Else
		GUICtrlSetState($mcinstall, $GUI_ENABLE)
	EndIf
EndFunc   ;==>_McAfee_State

Func _Office_State()
	If GUICtrlRead($addofficetoolbar) = 1 Then
		_State($GUI_ENABLE, $toolbar_group, $toolbardir2, "", "", "", "", "", "", "", "")
	Else
		_State($GUI_DISABLE, $toolbar_group, $toolbardir2, "", "", "", "", "", "", "", "")
	EndIf
EndFunc   ;==>_Office_State
Func _PrepsysToStartup()
	If GUICtrlRead($addprepsystostartup) = 1 Then
		_State($GUI_ENABLE, $group1, $label1, $PrepsysLocation, $BrowsePrepsysLocation, $label2, $settingsfile, $BrowseSettingsFile, $AutorunPrepsysOnStartup, $label3, $opentotab)
	Else
		_State($GUI_DISABLE, $group1, $label1, $PrepsysLocation, $BrowsePrepsysLocation, $label2, $settingsfile, $BrowseSettingsFile, $AutorunPrepsysOnStartup, $label3, $opentotab)
	EndIf
EndFunc   ;==>_PrepsysToStartup

Func _Sysprep_User_State()
	If GUICtrlRead($copyprofile) = 1 Then
		_State($GUI_ENABLE, $username2, $password2, $cplabel1, $cplabel2, $cpgroup, $user_create, $user_existing, $cplabel3, $domain2, $DeleteCopyProfileUser)
	Else
		_State($GUI_DISABLE, $username2, $password2, $cplabel1, $cplabel2, $cpgroup, $user_create, $user_existing, $cplabel3, $domain2, $DeleteCopyProfileUser)
	EndIf
EndFunc   ;==>_Sysprep_User_State

Func _Folder_Options_State()
	If GUICtrlRead($folderoptions) = 1 Then
		_State($GUI_ENABLE, $SearchNetPrinters, $DisplayFileSizeInFolderTips, $SimpleViewInFolderListView, $DisplaySystemFolderContents, $FullPathAddress, $FullPathTitle, $CacheThumbnails, $ShowHiddenFiles, $ShowFileExtensions, $ShowHiddenSysFiles)
		_State($GUI_ENABLE, $LaunchWindowsInSeperateProcess, $RememberFolderSettings, $RestoreWindowsAtLogon, $ControlPanelInMyComputer, $ShowCompressedFilesInColor, $ShowDesktopFolderInfoPopop, $UseSimpleFileSharing, "", "", "")
	Else
		_State($GUI_DISABLE, $SearchNetPrinters, $DisplayFileSizeInFolderTips, $SimpleViewInFolderListView, $DisplaySystemFolderContents, $FullPathAddress, $FullPathTitle, $CacheThumbnails, $ShowHiddenFiles, $ShowFileExtensions, $ShowHiddenSysFiles)
		_State($GUI_DISABLE, $LaunchWindowsInSeperateProcess, $RememberFolderSettings, $RestoreWindowsAtLogon, $ControlPanelInMyComputer, $ShowCompressedFilesInColor, $ShowDesktopFolderInfoPopop, $UseSimpleFileSharing, "", "", "")
	EndIf
EndFunc   ;==>_Folder_Options_State

Func _VisSettings_State()
	If GUICtrlRead($vissettings) = 1 Then
		_State($GUI_ENABLE, $AWWMAM, $FOSMIV, $FOSTIV, $SSUM, $SSUMP, $STSR, $SWCWD, $SOCB, $STB, $SEOSF)
		_State($GUI_ENABLE, $SSLB, $UABIFEFT, $UCTIF, $UDSFILOTD, $UVSOWAB, $mydocs, $mycomp, $mynetplaces, $iexplorer, $cleandesk)
		_State($GUI_ENABLE, $localimgname, $defaultimgname, $imglab1, $imglab2, $use_local_image, "", "", "", "", "")
		_LocalImage_State()
	Else
		_State($GUI_DISABLE, $AWWMAM, $FOSMIV, $FOSTIV, $SSUM, $SSUMP, $STSR, $SWCWD, $SOCB, $STB, $SEOSF)
		_State($GUI_DISABLE, $SSLB, $UABIFEFT, $UCTIF, $UDSFILOTD, $UVSOWAB, $mydocs, $mycomp, $mynetplaces, $iexplorer, $cleandesk)
		_State($GUI_DISABLE, $localimgname, $defaultimgname, $imglab1, $imglab2, $use_local_image, "", "", "", "", "")
	EndIf
EndFunc   ;==>_VisSettings_State

Func _LocalImage_State()
	If GUICtrlRead($use_local_image) = 1 Then
		GUICtrlSetState($localimgname, $GUI_ENABLE)
		GUICtrlSetState($imglab2, $GUI_ENABLE)
	Else
		GUICtrlSetState($localimgname, $GUI_DISABLE)
		GUICtrlSetState($imglab2, $GUI_DISABLE)
	EndIf
EndFunc   ;==>_LocalImage_State

Func _StartMenuState()
	If GUICtrlRead($startmenu) = 1 Then
		_State($GUI_ENABLE, $DisplayAdminTools, $DisplayFavories, $DisplayLogOff, $DisplayRun, $EnableDRAGandDROP, $ExpandControlPanel, $ExpandMyDocuments, $ExpandMyPictures, $ExpandNetworkConnections, $ExpandPrinters)
		_State($GUI_ENABLE, $ScrollPrograms, $UsePersonalizedMenus, $snclabel, $satlabel, $Classic_Menu, "", "", "", "", "")
		_State($GUI_ENABLE, $ShowControlPanel, $ShowMyComputer, $ShowMyDocs, $ShowMyMusic, $ShowMyPics, $ShowNetConn, $ShowAdminTools, $EnableDragDrop, $ScrollPrograms2, $ShowHelp)
		_State($GUI_ENABLE, $ShowPrinters, $ShowRun, $ShowSearch, $ShowSetProgramAccessAndDefaults, $StartMenuFavorites, $scplabel, $smclabel, $smdlabel, $smmlabel, $smplabel)
		_State($GUI_ENABLE, $LockTaskbar, $AutoHideTaskbar, $KeepTaskbarOnTop, $Group, $ShowQuickLaunch, $ShowClock, $HideInactiveIcons, "", "", "")
	Else
		_State($GUI_DISABLE, $DisplayAdminTools, $DisplayFavories, $DisplayLogOff, $DisplayRun, $EnableDRAGandDROP, $ExpandControlPanel, $ExpandMyDocuments, $ExpandMyPictures, $ExpandNetworkConnections, $ExpandPrinters)
		_State($GUI_DISABLE, $ScrollPrograms, $UsePersonalizedMenus, $snclabel, $satlabel, $Classic_Menu, "", "", "", "", "")
		_State($GUI_DISABLE, $ShowControlPanel, $ShowMyComputer, $ShowMyDocs, $ShowMyMusic, $ShowMyPics, $ShowNetConn, $ShowAdminTools, $EnableDragDrop, $ScrollPrograms2, $ShowHelp)
		_State($GUI_DISABLE, $ShowPrinters, $ShowRun, $ShowSearch, $ShowSetProgramAccessAndDefaults, $StartMenuFavorites, $scplabel, $smclabel, $smdlabel, $smmlabel, $smplabel)
		_State($GUI_DISABLE, $LockTaskbar, $AutoHideTaskbar, $KeepTaskbarOnTop, $Group, $ShowQuickLaunch, $ShowClock, $HideInactiveIcons, "", "", "")
	EndIf
EndFunc   ;==>_StartMenuState

Func _StartMenuSwitch()
	If GUICtrlRead($startmenu) = 1 Then
		If GUICtrlRead($Classic_Menu) = 1 Then
			_State($GUI_ENABLE, $DisplayAdminTools, $DisplayFavories, $DisplayLogOff, $DisplayRun, $EnableDRAGandDROP, $ExpandControlPanel, $ExpandMyDocuments, $ExpandMyPictures, $ExpandNetworkConnections, $ExpandPrinters)
			_State($GUI_ENABLE, $ScrollPrograms, $UsePersonalizedMenus, "", "", "", "", "", "", "", "")
			_State($GUI_DISABLE, $ShowControlPanel, $ShowMyComputer, $ShowMyDocs, $ShowMyMusic, $ShowMyPics, $ShowNetConn, $ShowAdminTools, $EnableDragDrop, $ScrollPrograms2, $ShowHelp)
			_State($GUI_DISABLE, $ShowPrinters, $ShowRun, $ShowSearch, $ShowSetProgramAccessAndDefaults, $StartMenuFavorites, $scplabel, $smclabel, $smdlabel, $smmlabel, $smplabel)
			_State($GUI_DISABLE, $snclabel, $satlabel, "", "", "", "", "", "", "", "")
		Else
			_State($GUI_DISABLE, $DisplayAdminTools, $DisplayFavories, $DisplayLogOff, $DisplayRun, $EnableDRAGandDROP, $ExpandControlPanel, $ExpandMyDocuments, $ExpandMyPictures, $ExpandNetworkConnections, $ExpandPrinters)
			_State($GUI_DISABLE, $ScrollPrograms, $UsePersonalizedMenus, "", "", "", "", "", "", "", "")
			_State($GUI_ENABLE, $ShowControlPanel, $ShowMyComputer, $ShowMyDocs, $ShowMyMusic, $ShowMyPics, $ShowNetConn, $ShowAdminTools, $EnableDragDrop, $ScrollPrograms2, $ShowHelp)
			_State($GUI_ENABLE, $ShowPrinters, $ShowRun, $ShowSearch, $ShowSetProgramAccessAndDefaults, $StartMenuFavorites, $scplabel, $smclabel, $smdlabel, $smmlabel, $smplabel)
			_State($GUI_ENABLE, $snclabel, $satlabel, "", "", "", "", "", "", "", "")
		EndIf
	EndIf
EndFunc   ;==>_StartMenuSwitch


Func _IniReadCheckbox_Ran($settings, ByRef $id, $name, $section1, $key1, $section2, $key2, $CR, $CT, $CW, $CH, $RR)
	$id = GUICtrlCreateCheckbox($name, $CR, $CT, $CW, $CH)
	If IniRead($settings, $section1, $key1, '') = 1 Then
		If IniRead($settings, $section2, $key2, '') = 0 Then GUICtrlSetState($id, $GUI_CHECKED)
	EndIf
	If IniRead($settings, $section2, $key2, '') = 1 Then GUICtrlCreatePic($workingdir & 'PrepSys\ran.bmp', $RR, $CT, $CH, $CH)
EndFunc   ;==>_IniReadCheckbox_Ran

Func _IniReadCheckbox($settings, ByRef $id, $name, $section1, $key1, $CR, $CT, $CW, $CH, $default = 0) ;Modified 6/14/07
	$id = GUICtrlCreateCheckbox($name, $CR, $CT, $CW, $CH)
	If IniRead($settings, $section1, $key1, $default) = 1 Then GUICtrlSetState($id, $GUI_CHECKED)
EndFunc   ;==>_IniReadCheckbox

Func _IniWriteCheckbox($settings, ByRef $id, $section1, $key1, $progress = '', $section2 = '', $key2 = '', $key3 = '', $key4 = '')
	If GUICtrlRead($id) = 1 Then
		If $progress = 1 Then _Progress_Ref('ADD_REF')
		IniWrite($settings, $section1, $key1, '1')
		If $key2 <> '' Then IniWrite($settings, $section2, $key2, '0')
		If $key3 <> '' Then IniWrite($settings, $section2, $key3, '0')
		If $key4 <> '' Then IniWrite($settings, $section2, $key4, '0')
	Else
		IniWrite($settings, $section1, $key1, '0')
		If $key2 <> '' Then IniWrite($settings, $section2, $key2, '0')
		If $key3 <> '' Then IniWrite($settings, $section2, $key3, '0')
		If $key4 <> '' Then IniWrite($settings, $section2, $key4, '0')
	EndIf
EndFunc   ;==>_IniWriteCheckbox

Func _LabeledCombo($settings, ByRef $id, ByRef $id2, $label, $section1, $key1, $item0, $item1, $item2, $R, $T, $W, $H, $LR, $LT, $LW, $LH)
	$id2 = GUICtrlCreateLabel($label, $LR, $T, $W, $H)
	$state = IniRead($settings, $section1, $key1, '')
	Select
		Case $state = 0
			$id = GUICtrlCreateCombo($item0, $R, $T, $W, $H)
			GUICtrlSetData(-1, $item1 & '|' & $item2)
		Case $state = 1
			$id = GUICtrlCreateCombo($item1, $R, $T, $W, $H)
			GUICtrlSetData(-1, $item2 & '|' & $item0)
		Case $state = 2
			$id = GUICtrlCreateCombo($item2, $R, $T, $W, $H)
			GUICtrlSetData(-1, $item1 & '|' & $item0)
	EndSelect
EndFunc   ;==>_LabeledCombo

Func _IniWriteCombo($settings, ByRef $id, $section1, $key1)
	Select
		Case GUICtrlRead($id) = 'Disabled'
			IniWrite($settings, $section1, $key1, '0')
		Case GUICtrlRead($id) = 'Link' Or GUICtrlRead($id) = 'Net Connections' Or GUICtrlRead($id) = 'Programs'
			IniWrite($settings, $section1, $key1, '1')
		Case GUICtrlRead($id) = 'Menu' Or GUICtrlRead($id) = 'Connect to' Or GUICtrlRead($id) = 'Start menu + progs'
			IniWrite($settings, $section1, $key1, '2')
	EndSelect
EndFunc   ;==>_IniWriteCombo

Func _FileBrowse($default, ByRef $input, ByRef $browse, $R, $T, $W, $H, $BR, $BW)
	$input = GUICtrlCreateInput($default, $R, $T, $W, $H)
	$browse = GUICtrlCreateButton('...', $BR, $T, $BW, $H)
EndFunc   ;==>_FileBrowse

Func _FileBrowseSet(ByRef $exe, $label, $type = 'AutoInstall (*.exe;*.bat)', $dialog = 'normal')
	If $dialog = 'advanced' Then
		$opendialog = _AdvancedFileOpenDialog($label, $workingdir, $type, 1)
		If $opendialog <> '' Then GUICtrlSetData($exe, $opendialog)
	ElseIf $dialog = 'folder' Then
		$opendialog = FileOpenDialog($label, $workingdir, $type, 2)
		If @error <> 1 Then GUICtrlSetData($exe, $opendialog)
	Else
		$opendialog = FileOpenDialog($label, $workingdir, $type, 1)
		If @error <> 1 Then GUICtrlSetData($exe, $opendialog)
	EndIf
EndFunc   ;==>_FileBrowseSet

Func _State(Const $state, Const $1, Const $2, Const $3, Const $4, Const $5, Const $6, Const $7, Const $8, Const $9, Const $10)
	If $1 <> "" Then GUICtrlSetState($1, $state)
	If $2 <> "" Then GUICtrlSetState($2, $state)
	If $3 <> "" Then GUICtrlSetState($3, $state)
	If $4 <> "" Then GUICtrlSetState($4, $state)
	If $5 <> "" Then GUICtrlSetState($5, $state)
	If $6 <> "" Then GUICtrlSetState($6, $state)
	If $7 <> "" Then GUICtrlSetState($7, $state)
	If $8 <> "" Then GUICtrlSetState($8, $state)
	If $9 <> "" Then GUICtrlSetState($9, $state)
	If $10 <> "" Then GUICtrlSetState($10, $state)
EndFunc   ;==>_State

Func _ExeLocationWrite(Const $orig, Const $file, Const $settings, $section1, $key1)
	;If GUICtrlRead($file) <> $orig Then
	IniWrite($settings, $section1, $key1, GUICtrlRead($file))
	;ElseIf GUICtrlRead($file) = "" Then
	;	IniDelete($settings, $section1, $key1)
	;EndIf
EndFunc   ;==>_ExeLocationWrite

Func _NetworkLogin($nlsettings, $nluser = '', $nlpass = '', $nldom = '')
	;set in ini file if you wanted the network logon credential promt to show
	If $requestnetwork = 1 Then
		IniWrite($nlsettings, "NetworkLogon", "NetLogon", "1")
	Else
		IniWrite($nlsettings, "NetworkLogon", "NetLogon", "0")
	EndIf
	
	;if user credentials are saved in the ini file, use those credentials
	If $netuser <> '' Then $nluser = $netuser
	If $netpass <> '' Then $nlpass = $netpass
	If $netdom <> '' Then $nldom = $netdom
	
	If $requestnetwork = 1 And $shownetprompt = 1 Then
		
		GUICreate("Network Logon", 186, 140)
		GUICtrlCreateLabel("Username", 0, 10, 50, 20)
		$netuser1 = GUICtrlCreateInput($nluser, 50, 10, 120, 20)
		GUICtrlCreateLabel("Password", 0, 40, 50, 20)
		$netpass1 = GUICtrlCreateInput($nlpass, 50, 40, 120, 20, $ES_PASSWORD)
		GUICtrlCreateLabel("Domain", 0, 70, 40, 20)
		$netdom1 = GUICtrlCreateInput($nldom, 50, 70, 120, 20)
		$skipnetlogon = GUICtrlCreateCheckbox("Skip logon prompt on next load", 5, 90, 180, 20)
		$continue = GUICtrlCreateButton("Continue", 20, 115, 70, 20)
		$exit = GUICtrlCreateButton("Exit", 100, 115, 70, 20)
		
		GUISetState()
		While 1
			$msg = GUIGetMsg()
			Select
				Case $msg = $GUI_EVENT_CLOSE Or $msg = $exit
					Exit
				Case $msg = $continue
					IniWrite($nlsettings, "NetworkLogon", "NetAdmin", GUICtrlRead($netuser1))
					IniWrite($nlsettings, "NetworkLogon", "NetPass", _StringEncrypt(1, GUICtrlRead($netpass1), "Prepsys", 2))
					IniWrite($nlsettings, "NetworkLogon", "NetDom", GUICtrlRead($netdom1))
					If GUICtrlRead($skipnetlogon) = 1 Then IniWrite($nlsettings, "NetworkLogon", "ShowNetLoginPrompt", 0)
					ExitLoop
				Case Else
					;;;
			EndSelect
		WEnd
		GUIDelete("Network Logon")
	EndIf
EndFunc   ;==>_NetworkLogin

Func _AdvancedFileOpenDialog($title, $directory, $filetypes, $options) ;Edited 11/27/06
	$install_file_command = ''
	$addfile = FileOpenDialog($title, $directory, $filetypes, $options)
	If Not @error Then
		;Seperate Path from File name
		$count = 0
		While StringInStr($addfile, "\", 0, $count + 1) <> 0 ;find last "\" in file path
			$count += 1
		WEnd
		$directory = StringTrimRight($addfile, StringLen($addfile) - StringInStr($addfile, "\", 0, $count));Path
		$filename = StringTrimLeft($addfile, StringInStr($addfile, "\", 0, $count));Filename
		;GUI
		GUICreate("Please Choose File Prefixes and Switches", 450, 160, -1, -1, BitOR($WS_OVERLAPPEDWINDOW, $WS_CLIPSIBLINGS))
		GUICtrlCreateGroup("Configuration File", 5, 10, 440, 65)
		$configmsg = GUICtrlCreateLabel("Config File", 10, 30, 430, 20)
		$load_config = GUICtrlCreateButton("Load Configuration", 230, 50, 130, 20)
		$save_config = GUICtrlCreateButton("Save Configuration", 90, 50, 130, 20)
		GUICtrlCreateLabel("Prefix", 10, 80, 30, 20)
		GUICtrlCreateLabel("File", 120, 80, 70, 20)
		GUICtrlCreateLabel("Switch(s)", 340, 80, 70, 20)
		$install_prefix = GUICtrlCreateInput("", 10, 100, 100, 20)
		$install_file = GUICtrlCreateInput($addfile, 120, 100, 210, 20)
		$install_switches = GUICtrlCreateInput("", 340, 100, 100, 20)
		$install_ok = GUICtrlCreateButton("Ok", 140, 130, 80, 20)
		$install_cancle = GUICtrlCreateButton("Cancle", 230, 130, 80, 20)
		;END GUI
		If StringInStr($addfile, ".msi") Then ;autofill prefix and switch if file is a msi
			GUICtrlSetData($install_prefix, "msiexec /i")
			GUICtrlSetData($install_switches, "/qb")
		EndIf
		GUISetState()
		While 1
			$msg = GUIGetMsg()
			Select
				Case $msg = $load_config
					IniReadSection($directory & '\Autorun_config.ini', $filename)
					If Not @error Then
						GUICtrlSetData($install_prefix, IniRead($directory & '\Autorun_config.ini', $filename, "Prefix", ""))
						GUICtrlSetData($install_switches, IniRead($directory & '\Autorun_config.ini', $filename, "Switches", ""))
					EndIf
				Case $msg = $save_config
					IniWrite($directory & '\Autorun_config.ini', $filename, "Prefix", GUICtrlRead($install_prefix))
					IniWrite($directory & '\Autorun_config.ini', $filename, "Switches", GUICtrlRead($install_switches))
					If StringInStr($addfile, ".msi") Then ;autofill prefix and switch if file is a msi
						GUICtrlSetData($install_prefix, "msiexec /i")
						GUICtrlSetData($install_switches, "/qb")
					EndIf
				Case $msg = $install_ok
					If GUICtrlRead($install_prefix) <> '' Then $install_file_command = $install_file_command & GUICtrlRead($install_prefix) & ' '
					If GUICtrlRead($install_file) <> '' Then $install_file_command = $install_file_command & '"' & GUICtrlRead($install_file) & '"'
					If GUICtrlRead($install_switches) <> '' Then $install_file_command = $install_file_command & ' ' & GUICtrlRead($install_switches)
					ExitLoop
				Case $msg = $install_cancle
					$install_file_command = ''
					ExitLoop
				Case Else
					If FileExists($directory & '\Autorun_config.ini') Then
						IniReadSection($directory & '\Autorun_config.ini', $filename)
						If Not @error Then
							If IniRead($directory & '\Autorun_config.ini', $filename, "Prefix", "") = GUICtrlRead($install_prefix) And IniRead($directory & '\Autorun_config.ini', $filename, "Switches", "") = GUICtrlRead($install_switches) Then
								GUICtrlSetData($configmsg, 'Configuration for ' & $filename & ' matches current settings')
							Else
								GUICtrlSetData($configmsg, 'Configuration for ' & $filename & ' does not match current settings')
							EndIf
						Else
							GUICtrlSetData($configmsg, 'Configuration for ' & $filename & ' not found')
						EndIf
					Else
						GUICtrlSetData($configmsg, 'No configuration file exists')
					EndIf
					Sleep(50)
			EndSelect
		WEnd
		GUIDelete("Please Choose File Prefixes and Switches")
	Else
		$install_file_command = ''
	EndIf
	Return $install_file_command
EndFunc   ;==>_AdvancedFileOpenDialog

Func _ChangeComputerName($newcomputername, $logonuser = "", $logonpass = "", $domain = "", $startprogram = "")
	RegWrite("HKLM\SYSTEM\CurrentControlSet\Control\ComputerName\ActiveComputerName", "ComputerName", "REG_SZ", $newcomputername)
	RegWrite("HKLM\SYSTEM\CurrentControlSet\Control\ComputerName\ComputerName\", "ComputerName", "REG_SZ", $newcomputername)
	RegWrite("HKLM\SYSTEM\CurrentControlSet\Services\Tcpip\Parameters", "ComputerName", "REG_SZ", $newcomputername)
	RegWrite("HKLM\SYSTEM\CurrentControlSet\Services\Tcpip\Parameters", "NV Hostname", "REG_SZ", StringTrimRight($newcomputername, StringLen($newcomputername) - 15)) ;limited to 15 chars to prevent crash 6/16/07
	_Shutdown("REBOOT", "ADD", $logonuser, $logonpass, $domain, $startprogram)
EndFunc   ;==>_ChangeComputerName

Func _JoinToDomain($strUserDomain, $strUser, $strPassword, $strComputer, $strComputerDomain, $strOU);joins compuer to domain
	GUICreate("Joining computer to domain", 392, 323, -1, -1, BitOR($WS_OVERLAPPEDWINDOW, $WS_CLIPSIBLINGS))
	GUICtrlCreateLabel("Machine Name:", 10, 10, 80, 20)
	$machine_nameJD = GUICtrlCreateInput($strComputer, 100, 10, 280, 20)
	GUICtrlCreateLabel("Join Domain:", 10, 40, 90, 20)
	$jointodomain = GUICtrlCreateInput($strComputerDomain, 100, 40, 280, 20)
	GUICtrlCreateLabel("OU:", 10, 70, 90, 20)
	$JoinToOU = GUICtrlCreateInput($strOU, 100, 70, 280, 20)
	GUICtrlCreateLabel("Username:", 10, 100, 90, 20)
	$usernameJD = GUICtrlCreateInput($strUser, 100, 100, 280, 20)
	GUICtrlCreateLabel("Password:", 10, 130, 90, 20)
	$passwordJD = GUICtrlCreateInput($strPassword, 100, 130, 280, 20, $ES_PASSWORD)
	GUICtrlCreateLabel("Domain", 10, 170, 80, 20)
	$domainJD = GUICtrlCreateInput($strUserDomain, 100, 170, 280, 20)
	$join_edit = GUICtrlCreateEdit("", 10, 230, 370, 170)
	GUISetState()
	
	;Join Domain Script
	Const $JOIN_DOMAIN = 1
	Const $ACCT_CREATE = 2
	Const $ACCT_DELETE = 4
	Const $WIN9X_UPGRADE = 16
	Const $DOMAIN_JOIN_IF_JOINED = 32
	Const $JOIN_UNSECURE = 64
	Const $MACHINE_PASSWORD_PASSED = 128
	Const $DEFERRED_SPN_SET = 256
	Const $INSTALL_INVOCATION = 262144
	
	Dim $strDomainUser
	Dim $strFailString
	Dim $strSucceedString
	
	GUICtrlSetData($join_edit, "Joining Domain")
	$strDomainUser = $strUserDomain & "\" & $strUser
	
	$objNetwork = ObjCreate("WScript.Network")
	$objComputer = ObjGet("winmgmts:{impersonationLevel=Impersonate}!\\" & _
			$strComputer & "\root\cimv2:Win32_ComputerSystem.Name='" & _
			$strComputer & "'")
	$ReturnValue = $objComputer.JoinDomainOrWorkGroup ($strComputerDomain, _
			$strPassword, _
			$strDomainUser, _
			$strOU, _
			$JOIN_DOMAIN + $ACCT_CREATE)
	
	If ($ReturnValue <> 0) Then
		;get the net helpmsg from the error code returned
		Dim $strHelpMsg, $command
		$command = "net helpmsg " & $ReturnValue
		
		$objShell = ObjCreate("WScript.Shell")
		$objScriptExec = $objShell.Exec ($command)
		
		; store the error message into strHelpMsg
		$strHelpMsg = $objScriptExec.StdOut.ReadAll ()
		$strFailString = "Join Failed" & @CRLF & _
				"Computer: " & $strComputer & @CRLF & _
				"Domain: " & $strComputerDomain & @CRLF & _
				"User Name: " & $strDomainUser & @CRLF & _
				"Error Message: " & $strHelpMsg
		GUICtrlSetData($join_edit, $strFailString)
		$join_button = GUICtrlCreateButton("Join Domain", 10, 200, 110, 20)
		$skip_button = GUICtrlCreateButton("Skip Joining Domain", 130, 200, 110, 20)
		GUISetState()
		While 1
			$msg = GUIGetMsg()
			Select
				Case $msg = $GUI_EVENT_CLOSE Or $msg = $skip_button
					GUIDelete("Joining computer to domain")
					ExitLoop
				Case $msg = $join_button
					$domainJD = GUICtrlRead($domainJD)
					$usernameJD = GUICtrlRead($usernameJD)
					$passwordJD = GUICtrlRead($passwordJD)
					$machine_nameJD = GUICtrlRead($machine_nameJD)
					$jointodomain = GUICtrlRead($jointodomain)
					$JoinToOU = GUICtrlRead($JoinToOU)
					GUIDelete("Joining computer to domain")
					_JoinToDomain($domainJD, $usernameJD, $passwordJD, $machine_nameJD, $jointodomain, $JoinToOU)
					ExitLoop
				Case Else
					Sleep(10)
			EndSelect
		WEnd
		Return 0
	Else
		$strSucceedString = "Join Succeeded" & @CRLF & _
				"Computer: " & $strComputer & @CRLF & _
				"Domain: " & $strComputerDomain & @CRLF & _
				"User Name: " & $strDomainUser
		_RecordData($strComputer, $strUser, $strUserDomain, $strOU)
		GUICtrlSetData($join_edit, $strSucceedString)
		Sleep(5000)
		GUIDelete("Joining Computer To Domain")
		Return 1
	EndIf
EndFunc   ;==>_JoinToDomain

Func _RecordData($strComputer, $strUser, $strUserDomain, $strOU)
	Dim $objConnection
	Dim $strConnection, $strSQL
	Dim $arrTemp1, $arrTemp2
	Dim $strNewOU
	
	;extract OU from full OU path
	$arrTemp1 = StringSplit($strOU, "=")
	$arrTemp2 = StringSplit($arrTemp1[1], ",")
	$strNewOU = $arrTemp2[0]
	
	
	;Create objects
	$objConnection = ObjCreate("ADODB.Connection")
	$objRS = ObjCreate("ADODB.RecordSet")
	
	;Connection String Value
	$strConnectstring = "Driver={SQL Server};Server=wscdata1;UID=joined_dbo;PWD=join2DB05;WSID=;Language=us_english;Database=Joined;DSN=;"
	
	;Open the Connection
	$objConnection.Open ($strConnectstring)
	
	;SQL statement
	$strSQL = "INSERT INTO computers " & _
			"(compName, " & _
			"usrName, " & _
			"domainName, " & _
			"OU) " & _
			"VALUES ('" & _
			$strComputer & "', '" & _
			$strUser & "', '" & _
			$strUserDomain & "', '" & _
			$strNewOU & "')"
	
	;execute SQL command
	$objConnection.execute ($strSQL)
	
	;close the connection and free up resources
	$objConnection.Close
	$objConnection = ""
EndFunc   ;==>_RecordData

Func _JoinDomainState()
	If GUICtrlRead($joindomain) = 1 Then
		_State($GUI_ENABLE, $MNlabel, $JTlabel, $join_to, $UNLabel, $JDusername, $PWLabel, $JDpassword, $UDlabel, $JD_domain, "")
		_State($GUI_ENABLE, $MakeJDUserAdmin, $UseServiceTagAsName, "", "", "", "", "", "", "", "")
		If GUICtrlRead($UseServiceTagAsName) = 1 Then
			$service_tag = _GetServiceTagFromWMI()
			GUICtrlSetData($machine_name, "D" & $service_tag)
			_State($GUI_DISABLE, $machine_name, "", "", "", "", "", "", "", "", "")
		Else
			_State($GUI_ENABLE, $machine_name, "", "", "", "", "", "", "", "", "")
		EndIf
		If GUICtrlRead($MakeJDUserAdmin) = 1 Then
			_State($GUI_ENABLE, $UseJDUserAsDefaultAdmin, $UseJDUserAsCopyProfileUser, $RemoveJDAdminRights, "", "", "", "", "", "", "")
		Else
			_State($GUI_UNCHECKED, $UseJDUserAsDefaultAdmin, $UseJDUserAsCopyProfileUser, $RemoveJDAdminRights, "", "", "", "", "", "", "")
			_State($GUI_DISABLE, $UseJDUserAsDefaultAdmin, $UseJDUserAsCopyProfileUser, $RemoveJDAdminRights, "", "", "", "", "", "", "")
		EndIf
		If GUICtrlRead($UseJDUserAsDefaultAdmin) = 1 Then
			_State($GUI_DISABLE, $UseJDUserAsCopyProfileUser, "", "", "", "", "", "", "", "", "")
		ElseIf GUICtrlRead($UseJDUserAsDefaultAdmin) = 4 And GUICtrlRead($MakeJDUserAdmin) = 1 Then
			_State($GUI_ENABLE, $UseJDUserAsCopyProfileUser, "", "", "", "", "", "", "", "", "")
		EndIf
		If GUICtrlRead($UseJDUserAsCopyProfileUser) = 1 Then
			_State($GUI_DISABLE, $UseJDUserAsDefaultAdmin, "", "", "", "", "", "", "", "", "")
		ElseIf GUICtrlRead($UseJDUserAsCopyProfileUser) = 4 And GUICtrlRead($MakeJDUserAdmin) = 1 Then
			_State($GUI_ENABLE, $UseJDUserAsDefaultAdmin, "", "", "", "", "", "", "", "", "")
		EndIf
	Else
		_State($GUI_DISABLE, $MNlabel, $machine_name, $JTlabel, $join_to, $UNLabel, $JDusername, $PWLabel, $JDpassword, $UDlabel, $JD_domain)
		_State($GUI_DISABLE, $MakeJDUserAdmin, $UseJDUserAsDefaultAdmin, $UseJDUserAsCopyProfileUser, $RemoveJDAdminRights, $UseServiceTagAsName, "", "", "", "", "")
		If GUICtrlRead($UseServiceTagAsName) = 1 Then
			$service_tag = _GetServiceTagFromWMI()
			GUICtrlSetData($machine_name, "D" & $service_tag)
		EndIf
	EndIf
EndFunc   ;==>_JoinDomainState

Func _GetServiceTagFromWMI()
	$colItems = ""
	$servicetag = ""
	$strComputer = "localhost"
	$wbemFlagReturnImmediately = 0x10
	$wbemFlagForwardOnly = 0x20
	$objWMIService = ObjGet("winmgmts:\\" & $strComputer & "\root\CIMV2")
	$colItems = $objWMIService.ExecQuery ("SELECT * FROM Win32_SystemEnclosure", "WQL", $wbemFlagReturnImmediately + $wbemFlagForwardOnly)

	If IsObj($colItems) Then
		For $objItem In $colItems
			$servicetag = StringUpper($objItem.SerialNumber)
		Next
	Else
		MsgBox(0, "WMI Output", "No WMI Objects Found for class: " & "Win32_SystemEnclosure")
	EndIf
	Return ($servicetag)
EndFunc   ;==>_GetServiceTagFromWMI